package com.retrytech.strangerapp.retrofit;


import com.retrytech.strangerapp.modal.User;
import com.retrytech.strangerapp.modal.coinpackage.CoinPackages;
import com.retrytech.strangerapp.modal.fakeuser.FakeUser;
import com.retrytech.strangerapp.modal.searchuser.SearchUser;
import com.retrytech.strangerapp.modal.settings.AppSettings;
import com.retrytech.strangerapp.modal.token.AgoraToken;

import java.util.HashMap;

import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import retrofit2.Call;
import retrofit2.http.Field;
import retrofit2.http.FieldMap;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.Header;
import retrofit2.http.Multipart;
import retrofit2.http.POST;
import retrofit2.http.Part;
import retrofit2.http.PartMap;


public interface RetrofitService {

    @FormUrlEncoded
    @POST("removeCoins")
    Call<AppSettings> removeCoins(@Header("apikey") String apiKey,
                                  @Field("user_id") int userId,
                                  @Field("coin") int coin);


    @FormUrlEncoded
    @POST("addReport")
    Call<AppSettings> addReportForUser(@Header("apikey") String apiKey,
                                       @Field("description") String description,
                                       @Field("reason") String reason,
                                       @Field("contact") String contact,
                                       @Field("user_id") int user_id);


    @FormUrlEncoded
    @POST("token")
    Call<AgoraToken> generateToken(@Header("apikey") String apiKey,
                                   @Field("channelName") String channelName,
                                   @Field("appid") String appId,
                                   @Field("appcertificate") String appCertificate);


    @FormUrlEncoded
    @POST("removeUser")
    Call<AppSettings> deleteUser(@Header("apikey") String apiKey,
                                 @Field("user_id") int userId);

    @POST("getFackUser")
    Call<FakeUser> fetchFakeUsers(@Header("apikey") String apiKey);

    @POST("getPackage")
    Call<CoinPackages> fetchCoinPackages(@Header("apikey") String apiKey);

    @FormUrlEncoded
    @POST("addCoins")
    Call<AppSettings> addCoins(@Header("apikey") String apiKey,
                               @Field("user_id") int userId,
                               @Field("coin") int coin);

    @FormUrlEncoded
    @POST("getSettingData")
    Call<AppSettings> fetchSettingsData(@Header("apikey") String apiKey,
                                        @Field("type") int type);

    @FormUrlEncoded
    @POST("updateGender")
    Call<AppSettings> updateGender(@Header("apikey") String apiKey,
                                   @Field("gender") int gender,
                                   @Field("user_id") int userId);

    @FormUrlEncoded
    @POST("getUser")
    Call<User> registerUser(@Header("apikey") String apiKey,
                            @FieldMap HashMap<String, Object> hashMap);

    @FormUrlEncoded
    @POST("searchCall")
    Call<SearchUser> searchForCall(@Header("apikey") String apiKey,
                                   @FieldMap HashMap<String, Object> hashMap);

    @FormUrlEncoded
    @POST("destroy")
    Call<User> resetUserCallStatus(@Header("apikey") String apiKey,
                                   @Field("id") int userId);

    @FormUrlEncoded
    @POST("getconnecteduser")
    Call<User> getConnectedUser(@Header("apikey") String apiKey,
                                @Field("id") int userId,
                                @Field("token") String token);


    @FormUrlEncoded
    @POST("blockUserForUser")
    Call<User> blockUserForUser(@Header("apikey") String apiKey,
                                @Field("user_id") int userId,
                                @Field("block_user_ids") String token);

    @Multipart
    @POST("editUser")
    Call<User> editUser(@Header("apikey") String apiKey,
                        @PartMap HashMap<String, RequestBody> hashMap,
                        @Part MultipartBody.Part imagePart);


}
