package com.retrytech.strangerapp.activity;

import android.app.Dialog;
import android.content.Intent;
import android.graphics.drawable.ColorDrawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowInsets;
import android.widget.Toast;

import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;
import androidx.databinding.DataBindingUtil;

import com.retrytech.strangerapp.R;
import com.retrytech.strangerapp.databinding.ActivityReportBinding;
import com.retrytech.strangerapp.modal.settings.AppSettings;
import com.retrytech.strangerapp.retrofit.Const;
import com.retrytech.strangerapp.retrofit.RetrofitClient;
import com.retrytech.strangerapp.utils.SessionManager;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class ReportActivity extends AppCompatActivity {

    ActivityReportBinding binding;
    int userId;
    String reason, description, contactDetails;
    private Dialog dialog;
    SessionManager sessionManager;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        View decorView = getWindow().getDecorView();
        decorView.setOnApplyWindowInsetsListener((v, insets) -> {
            WindowInsets defaultInsets = v.onApplyWindowInsets(insets);
            return defaultInsets.replaceSystemWindowInsets(
                    defaultInsets.getSystemWindowInsetLeft(),
                    0,
                    defaultInsets.getSystemWindowInsetRight(),
                    defaultInsets.getSystemWindowInsetBottom());
        });
        ViewCompat.requestApplyInsets(decorView);
        getWindow().setStatusBarColor(ContextCompat.getColor(this, android.R.color.transparent));

        binding = DataBindingUtil.setContentView(this, R.layout.activity_report);
        sessionManager = new SessionManager(this);
        userId = getIntent().getIntExtra("userId", -1);

        dialog = new Dialog(this);
        View dialogueView = LayoutInflater.from(this).inflate(R.layout.item_loader, null, false);
        dialog.setContentView(dialogueView);
        dialog.setCancelable(false);
        dialog.setCanceledOnTouchOutside(false);
        dialog.getWindow().setBackgroundDrawable(new ColorDrawable(ContextCompat.getColor(this, android.R.color.transparent)));

        binding.imgBack.setOnClickListener(view -> {
            onBackPressed();
        });

        binding.tvTerm.setOnClickListener(view -> {
            Intent browserIntent = new Intent(Intent.ACTION_VIEW, Uri.parse(sessionManager.getAppSettings().getMiscs().getTerms()));
            startActivity(browserIntent);
        });


        binding.btnReport.setOnClickListener(view -> {

            reason = (String) binding.spinner.getSelectedItem();
            Log.d("TAG", "onCreate: " + reason);

            if (reason.isEmpty()) {
                Toast.makeText(ReportActivity.this, getResources().getString(R.string.please_select_reason), Toast.LENGTH_SHORT).show();
                return;
            }
            if (binding.etDescription.getText().toString().isEmpty()) {
                Toast.makeText(ReportActivity.this, getResources().getString(R.string.please_enter_description), Toast.LENGTH_SHORT).show();
                return;
            }
            if (binding.etContact.getText().toString().isEmpty()) {
                Toast.makeText(ReportActivity.this, getResources().getString(R.string.please_contact_details), Toast.LENGTH_SHORT).show();
                return;
            }

            description = binding.etDescription.getText().toString();
            contactDetails = binding.etContact.getText().toString();


            dialog.show();
            if (userId == -1) {
                new Handler().postDelayed(() -> {

                    onBackPressed();
                    Toast.makeText(ReportActivity.this, getResources().getString(R.string.report_submitted_successfully), Toast.LENGTH_SHORT).show();
                    dialog.dismiss();
                }, 2000);
                return;
            }

            Call<AppSettings> call = RetrofitClient.getService().addReportForUser(Const.API_KEY, description, reason, contactDetails, userId);
            call.enqueue(new Callback<AppSettings>() {
                @Override
                public void onResponse(Call<AppSettings> call, Response<AppSettings> response) {
                    if (response.body() != null) {
                        onBackPressed();
                        Toast.makeText(ReportActivity.this, getResources().getString(R.string.report_submitted_successfully), Toast.LENGTH_SHORT).show();
                        dialog.dismiss();
                    }
                }

                @Override
                public void onFailure(Call<AppSettings> call, Throwable t) {
                    onBackPressed();
                    Toast.makeText(ReportActivity.this, getResources().getString(R.string.something_went_wrong), Toast.LENGTH_SHORT).show();
                    dialog.dismiss();
                }
            });
        });
    }
}