package com.retrytech.strangerapp.activity;

import android.app.Dialog;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.net.Uri;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowInsets;

import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;
import androidx.databinding.DataBindingUtil;

import com.bumptech.glide.Glide;
import com.google.android.gms.auth.api.signin.GoogleSignIn;
import com.google.android.gms.auth.api.signin.GoogleSignInOptions;
import com.retrytech.strangerapp.R;
import com.retrytech.strangerapp.databinding.ActivityProfileBinding;
import com.retrytech.strangerapp.databinding.ItemConfirmationPopupBinding;
import com.retrytech.strangerapp.modal.settings.AppSettings;
import com.retrytech.strangerapp.retrofit.Const;
import com.retrytech.strangerapp.retrofit.RetrofitClient;
import com.retrytech.strangerapp.utils.SessionManager;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class ProfileActivity extends AppCompatActivity {
    ActivityProfileBinding binding;
    SessionManager sessionManager;
    private Dialog processdialog;
    private GoogleSignInOptions gso;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        View decorView = getWindow().getDecorView();
        decorView.setOnApplyWindowInsetsListener((v, insets) -> {
            WindowInsets defaultInsets = v.onApplyWindowInsets(insets);
            return defaultInsets.replaceSystemWindowInsets(
                    defaultInsets.getSystemWindowInsetLeft(),
                    0,
                    defaultInsets.getSystemWindowInsetRight(),
                    defaultInsets.getSystemWindowInsetBottom());
        });
        ViewCompat.requestApplyInsets(decorView);
        getWindow().setStatusBarColor(ContextCompat.getColor(this, android.R.color.transparent));


        binding = DataBindingUtil.setContentView(this, R.layout.activity_profile);
        sessionManager = new SessionManager(this);
        gso = new GoogleSignInOptions.Builder(GoogleSignInOptions.DEFAULT_SIGN_IN)
                .requestEmail()
                .build();


        processdialog = new Dialog(this);
        View dialogueView = LayoutInflater.from(this).inflate(R.layout.item_loader, null, false);
        processdialog.setContentView(dialogueView);
        processdialog.setCancelable(false);
        processdialog.setCanceledOnTouchOutside(false);
        processdialog.getWindow().setBackgroundDrawable(new ColorDrawable(ContextCompat.getColor(this, android.R.color.transparent)));


        binding.imgBack.setOnClickListener(view -> onBackPressed());

        Glide.with(this)
                .load(Const.ITEM_URL + sessionManager.getUser().getData().getImage())
                .circleCrop()
                .into(binding.imgProfile);

        binding.tvFullname.setText(sessionManager.getUser().getData().getFullname());
        binding.tvEditProfile.setOnClickListener(view -> {
            startActivity(new Intent(ProfileActivity.this, EditProfileActivity.class));
        });
        binding.tvWallet.setOnClickListener(view -> startActivity(new Intent(ProfileActivity.this, WalletActivity.class)));

        binding.tvPrivacy.setOnClickListener(view -> {
            Intent browserIntent = new Intent(Intent.ACTION_VIEW, Uri.parse(sessionManager.getAppSettings().getMiscs().getPrivcyUrl()));
            startActivity(browserIntent);
        });

        binding.tvTerms.setOnClickListener(view -> {
            Intent browserIntent = new Intent(Intent.ACTION_VIEW, Uri.parse(sessionManager.getAppSettings().getMiscs().getTerms()));
            startActivity(browserIntent);
        });

        binding.tvDeleteMyAcc.setOnClickListener(view2 -> {
            Dialog dialog = new Dialog(this);
            dialog.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
            View view = LayoutInflater.from(this).inflate(R.layout.item_confirmation_popup, null, false);
            ItemConfirmationPopupBinding confirmationPopupBinding = DataBindingUtil.bind(view);

            confirmationPopupBinding.tvMessage.setText(getResources().getString(R.string.delete_acc_message));

            confirmationPopupBinding.btnYes.setOnClickListener(view1 -> {
                dialog.dismiss();
                callApiToDeleteAccount();
            });
            confirmationPopupBinding.btnCancel.setOnClickListener(view1 -> dialog.dismiss());
            dialog.setContentView(view);
            dialog.setCancelable(false);
            dialog.show();

        });

        binding.tvLogOut.setOnClickListener(view2 -> {
            Dialog dialog = new Dialog(this);
            dialog.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
            View view = LayoutInflater.from(this).inflate(R.layout.item_confirmation_popup, null, false);
            ItemConfirmationPopupBinding confirmationPopupBinding = DataBindingUtil.bind(view);

            confirmationPopupBinding.tvMessage.setText(getResources().getString(R.string.log_out_message));

            confirmationPopupBinding.btnYes.setOnClickListener(view1 -> {
                GoogleSignIn.getClient(this, gso).signOut();
                sessionManager.clear();
                dialog.dismiss();
                startActivity(new Intent(this, SplashActivity.class));
                finishAffinity();
            });
            confirmationPopupBinding.btnCancel.setOnClickListener(view1 -> dialog.dismiss());
            dialog.setContentView(view);
            dialog.setCancelable(false);
            dialog.show();
        });


    }

    private void callApiToDeleteAccount() {
        processdialog.show();
        Call<AppSettings> call = RetrofitClient.getService().deleteUser(Const.API_KEY, sessionManager.getUser().getData().getId());
        call.enqueue(new Callback<AppSettings>() {
            @Override
            public void onResponse(Call<AppSettings> call, Response<AppSettings> response) {
                if (response.body() != null) {
                    AppSettings settings = response.body();
                    if (settings.isStatus()) {
                        GoogleSignIn.getClient(ProfileActivity.this, gso).signOut();
                        sessionManager.clear();
                        processdialog.dismiss();
                        startActivity(new Intent(ProfileActivity.this, SplashActivity.class));
                        finishAffinity();
                    }
                }
            }

            @Override
            public void onFailure(Call<AppSettings> call, Throwable t) {

            }
        });
    }
}